ORCA/M Asm65816 2.1.0

0001 FCF2                       title 'Queue Stuff' 
0002 FCF2              **********************************************************************
0003 FCF2              *
0004 FCF2              * Queue Stuff
0005 FCF2              * Copyright (C) 1988
0006 FCF2              * Apple Computer, Inc.
0007 FCF2              * All Rights Reserved
0008 FCF2              *
0009 FCF2              * This file contains the routines
0010 FCF2              *
0011 FCF2              *      AddToQueue
0012 FCF2              *      DeleteFromQueue
0013 FCF2              *
0014 FCF2              *
0015 FCF2              **********************************************************************
0016 FCF2
0017 FCF2                       include 'all.macros' 
0018 FCF2                       include 'mt.equates.asm' 
0019 FCF2                       include '::sys.equs.asm' 
0020 FCF2                       title 'AddToQueue' 
0021 FCF2              ****************************************************************
0022 FCF2              *
0023 FCF2              AddToQueue PROC EXPORT 
0024 FCF2              *
0025 FCF2              * This routine adds the indicated record to the link list
0026 FCF2              * that starts at PtrToFirstPtr.
0027 FCF2              *
0028 FCF2              * If FirstPtr is zero, then the new pointer will be
0029 FCF2              * stored at PtrToFirstPtr.
0030 FCF2              *
0031 FCF2              * The link in the header field of the new record is zeroed.
0032 FCF2              *
0033 FCF2              * Before the items are linked, the signature word of the 
0034 FCF2              * header record is checked.  If the signature is not valid,
0035 FCF2              * and error is returned and no linkage is made.
0036 FCF2              *
0037 FCF2              *
0038 FCF2              * Inputs:
0039 FCF2              *                   Pointer To Record to Add
0040 FCF2              *                   Pointer To Pointer to First Record
0041 FCF2              *
0042 FCF2              * Outputs:
0043 FCF2              *                   none
0044 FCF2              *
0045 FCF2              * External Refs:
0046 FCF2                       import oErrOut8 
0047 FCF2                       import FindMatch 
0048 FCF2              *
0049 FCF2              * Entry Points:
0050 FCF2              *                   none
0051 FCF2              *
0052 FCF2                       longa on                       ; mode
0053 FCF2                       longi on
0054 FCF2              *
0055 FCF2              * Change History
0056 FCF2              *
0057 FCF2              * 12 Jan 88         Steven Glass
0058 FCF2              *
0059 FCF2              * Added code to check and see if the specified entry was
0060 FCF2              * already in the queue.  When it is an error is returned.
0061 FCF2              *
0062 FCF2              ****************************************************************
0063 FCF2
0064 FCF2                       DefineStack 
0065 FCF2              OrigD    WORD 
0066 FCF2              CurPtr   LONG 
0067 FCF2              RTL1     block 3
0068 FCF2              rtl2     block 3
0069 FCF2              PtrToFirstPtr LONG 
0070 FCF2              RoutinePtr LONG 
0071 FCF2
0072 FCF2              PriorPtr equ   PtrToFirstPtr            ; better name for this location when in
0073 FCF2                                                      ; loop.
0074 FCF2
0075 FCF2
0076 FCF2 48                    pha                            ; put space for CurPtr on stack
0077 FCF3 48                    pha   
0078 FCF4 0B                    phd                            ; save d-reg
0079 FCF5 3B                    tsc                            ; turn stack to d-page
0080 FCF6 5B                    tcd   
0081 FCF7
0082 FCF7              ;-----------------------------------------------------------
0083 FCF7              ;
0084 FCF7              ; Make sure that the signature is correct.
0085 FCF7              ;
0086 FCF7 A0 06 00              ldy   #HeaderSignature
0087 FCFA B7 11                 lda   [RoutinePtr],y
0088 FCFC C9 5A A5              cmp   #QueueSignature
0089 FCFF D0 39                 bne   SigError
0090 FD01
0091 FD01 48                    pha                            ; space for result
0092 FD02 48                    pha   
0093 FD03 D4 13                 pei   RoutinePtr+2
0094 FD05 D4 11                 pei   RoutinePtr
0095 FD07 D4 0F                 pei   PtrToFirstPtr+2          ; save the pointer to the first pointer
0096 FD09 D4 0D                 pei   PtrToFirstPtr
0097 FD0B
0098 FD0B 20 85 FD              jsr   FindMatch                ; no match should be found
0099 FD0E B0 07                 bcs   Continue
0100 FD10
0101 FD10 68                    pla   
0102 FD11 68                    pla   
0103 FD12 A2 82 03              ldx   #AlreadyInQueue
0104 FD15 80 1C                 bra   AllDone
0105 FD17
0106 FD17              Continue  
0107 FD17
0108 FD17              ;
0109 FD17              ; Restore the pointer to the first pointer.
0110 FD17              ;
0111 FD17 68 85 0D 68           PullLong PriorPtr 
0112 FD1D
0113 FD1D              ;-----------------------------------------------------------
0114 FD1D              ;
0115 FD1D              ; Signature is ok, find the end and link it in.
0116 FD1D              ;
0117 FD1D
0118 FD1D A0 02 00              ldy   #2                       ; set y to 2 and leave this way until end
0119 FD20
0120 FD20 08                    php                            ; save state of system
0121 FD21 78                    sei                            ; turn off interrupts
0122 FD22
0123 FD22
0124 FD22              ;-----------------------------------------------------------
0125 FD22              ;
0126 FD22              ; We got the last one.  Link the new record into the last
0127 FD22              ; one and zero the link in the new one.
0128 FD22              ;
0129 FD22 A5 11        FoundEnd lda   RoutinePtr               ; Put the pointer to the new routine in the 
0130 FD24 87 0D                 sta   [PriorPtr]               ; space provided in last
0131 FD26 A5 13                 lda   RoutinePtr+2
0132 FD28 97 0D                 sta   [PriorPtr],y
0133 FD2A
0134 FD2A A9 00 00              lda   #0                       ; zero the link field of the new routine
0135 FD2D 87 11                 sta   [RoutinePtr]
0136 FD2F 97 11                 sta   [RoutinePtr],y
0137 FD31
0138 FD31              ;-----------------------------------------------------------
0139 FD31              ;
0140 FD31              ; Restore interrupts, clear error code and fall into 
0141 FD31              ; exit routine.
0142 FD31              ;
0143 FD31 28                    plp   
0144 FD32
0145 FD32 AA                    tax                            ; put zero in x
0146 FD33
0147 FD33 2B           AllDone  pld   
0148 FD34 68                    pla   
0149 FD35 68                    pla   
0150 FD36 5C 3E FC FE           jml   oErrOut8
0151 FD3A
0152 FD3A
0153 FD3A              SigError  
0154 FD3A A2 81 03              ldx   #BadSignature
0155 FD3D 80 F4                 bra   AllDone
0156 FD3F
0157 FD3F                       ENDP 
0158 FD3F
0159 FD3F
0160 FD3F                       title 'DeleteFromQueue' 
0161 FD3F              ****************************************************************
0162 FD3F              *
0163 FD3F              DeleteFromQueue PROC EXPORT 
0164 FD3F              *
0165 FD3F              * Removes the indicated record from the linked list.  First it
0166 FD3F              * checks the record for the required signature word.  If the 
0167 FD3F              * signature is not there, an error is returned.
0168 FD3F              *
0169 FD3F              * If the signature is ok, then we searc the list from the
0170 FD3F              * beginning for the indicated record.  When the record is found,
0171 FD3F              * its next field is put in the the next field of the prior record.
0172 FD3F              *
0173 FD3F              * If the record is not found, an error is returned.
0174 FD3F              *
0175 FD3F              *
0176 FD3F              * Inputs:
0177 FD3F              *                   Pointer to Record To Remove
0178 FD3F              *                   Pointer to First Record Pointer
0179 FD3F              *
0180 FD3F              * Outputs:
0181 FD3F              *                   none
0182 FD3F              *
0183 FD3F              * External Refs:
0184 FD3F                       import oErrOut8 
0185 FD3F                       import FindMatch 
0186 FD3F              *
0187 FD3F              * Entry Points:
0188 FD3F              *
0189 FD3F                       longa on                       ; mode
0190 FD3F                       longi on
0191 FD3F              *
0192 FD3F              *
0193 FD3F              * Change History
0194 FD3F              *
0195 FD3F              * 12 Jan 88         Steven Glass
0196 FD3F              *
0197 FD3F              * Made code that searches for the specified pointer a 
0198 FD3F              * subroutine so that it can be called by AddToQueue.
0199 FD3F              *
0200 FD3F              * Changed this call to use subroutine.
0201 FD3F              *
0202 FD3F              ****************************************************************
0203 FD3F
0204 FD3F                       DefineStack 
0205 FD3F              OrigD    WORD 
0206 FD3F              CurPtr   LONG 
0207 FD3F              RTL1     block 3 
0208 FD3F              rtl2     block 3 
0209 FD3F              PtrToFirstPtr LONG 
0210 FD3F              RoutinePtr LONG 
0211 FD3F
0212 FD3F
0213 FD3F              PriorPtr equ   PtrToFirstPtr            ; better name for this location when in
0214 FD3F                                                      ; loop.
0215 FD3F
0216 FD3F
0217 FD3F
0218 FD3F 48                    pha                            ; put space on stack for CurPtr
0219 FD40 48                    pha   
0220 FD41 0B                    phd                            ; save d-page
0221 FD42 3B                    tsc                            ; turn stack to dpage
0222 FD43 5B                    tcd   
0223 FD44
0224 FD44              ;-----------------------------------------------------------
0225 FD44              ;
0226 FD44              ; Check the signature.  If it is not correct, we're
0227 FD44              ; done now.
0228 FD44              ;
0229 FD44 A0 06 00              ldy   #HeaderSignature
0230 FD47 B7 11                 lda   [RoutinePtr],y
0231 FD49 C9 5A A5              cmp   #QueueSignature
0232 FD4C D0 32                 bne   SigError
0233 FD4E
0234 FD4E
0235 FD4E              ;-----------------------------------------------------------
0236 FD4E              ;
0237 FD4E              ; Routine signature is ok, lets find the indicated record.
0238 FD4E              ;
0239 FD4E              SigOK     
0240 FD4E
0241 FD4E 48                    pha                            ; space for result
0242 FD4F 48                    pha   
0243 FD50 D4 13                 pei   RoutinePtr+2
0244 FD52 D4 11                 pei   RoutinePtr
0245 FD54 D4 0F                 pei   PtrToFirstPtr+2          ; save the pointer to the first pointer
0246 FD56 D4 0D                 pei   PtrToFirstPtr
0247 FD58 20 85 FD              jsr   FindMatch
0248 FD5B 68 85 0D 68           PullLong PriorPtr 
0249 FD61 90 05                 bcc   FoundIt
0250 FD63
0251 FD63
0252 FD63              ;-----------------------------------------------------------
0253 FD63              ;
0254 FD63              ; We go to the end without finding the record.  Restore
0255 FD63              ; interrupt state, put error code in x and join
0256 FD63              ; common exit routine.
0257 FD63              ;
0258 FD63 A2 80 03              ldx   #RecordNotFound
0259 FD66 80 11                 bra   AllDone
0260 FD68
0261 FD68
0262 FD68              FoundIt   
0263 FD68 A0 02 00              ldy   #2                       ; we set y to 2 here and not touch it again
0264 FD6B                                                      ; in this routine
0265 FD6B
0266 FD6B              ;-----------------------------------------------------------
0267 FD6B              ;
0268 FD6B              ; Manipulate the Queue with interrupts off.
0269 FD6B              ;
0270 FD6B 08                    php                            ; save state of system
0271 FD6C 78                    sei                            ; turn off interrupts
0272 FD6D
0273 FD6D
0274 FD6D
0275 FD6D              ;-----------------------------------------------------------
0276 FD6D              ;
0277 FD6D              ; We found it.  Take the value in the link field and put
0278 FD6D              ; it in the link field of the previous record.
0279 FD6D              ;
0280 FD6D A7 11                 lda   [RoutinePtr]
0281 FD6F 87 0D                 sta   [PriorPtr]
0282 FD71 B7 11                 lda   [RoutinePtr],y
0283 FD73 97 0D                 sta   [PriorPtr],y
0284 FD75
0285 FD75              ;-----------------------------------------------------------
0286 FD75              ;
0287 FD75              ; Restore interrupts, set error code and join common
0288 FD75              ; exit code.
0289 FD75              ;
0290 FD75 28                    plp   
0291 FD76 A2 00 00              ldx   #0
0292 FD79
0293 FD79
0294 FD79              ;-----------------------------------------------------------
0295 FD79              ;
0296 FD79              ; Exit now
0297 FD79              ;
0298 FD79
0299 FD79 2B           AllDone  pld                            ; restore d-page
0300 FD7A 68                    pla                            ; clear off CurPtr
0301 FD7B 68                    pla   
0302 FD7C 5C 3E FC FE           jml   oErrOut8                 ; clean up stack.
0303 FD80
0304 FD80              ;-----------------------------------------------------------
0305 FD80              ;
0306 FD80              ; There was a signature error.  Set the error code and get
0307 FD80              ; out.
0308 FD80              ;
0309 FD80              SigError  
0310 FD80 A2 81 03              ldx   #BadSignature            ; error returned in x-reg
0311 FD83 80 F4                 bra   AllDone
0312 FD85
0313 FD85                       ENDP 
0314 FD85
0315 FD85              ****************************************************************
0316 FD85              *
0317 FD85              FindMatch PROC 
0318 FD85              *
0319 FD85              * Searches for the specified entry in the indicated queue.
0320 FD85              *
0321 FD85              * If the entry is found, the carry returns clear.
0322 FD85              * If the entry is not found, the carry returns set.
0323 FD85              *
0324 FD85              * The output is the pointer to the entry that points to 
0325 FD85              * the specified entry, or the last entry in the list if no 
0326 FD85              * match is found.
0327 FD85              *
0328 FD85              *
0329 FD85              * Inputs:
0330 FD85              *                   Space For Result
0331 FD85              *                   Routine Ptr
0332 FD85              *                   PtrToFirstPtr
0333 FD85              *
0334 FD85              * Outputs:
0335 FD85              *                   Entry That Points to Matching Entry
0336 FD85              *                   Carry Clear indicates match
0337 FD85              *                   Carry set indicates no match.
0338 FD85              *
0339 FD85              * External Refs:
0340 FD85              *                   none
0341 FD85              *
0342 FD85              * Entry Points:
0343 FD85              *                   none
0344 FD85              *
0345 FD85                       longa on                       ; mode
0346 FD85                       longi on
0347 FD85              *
0348 FD85              ****************************************************************
0349 FD85                       DefineStack 
0350 FD85              OrigD    word 
0351 FD85              RTS      word 
0352 FD85              PtrToFirstPtr LONG 
0353 FD85              RoutinePtr LONG 
0354 FD85              CurPtr   LONG 
0355 FD85
0356 FD85 0B                    phd   
0357 FD86 3B                    tsc   
0358 FD87 5B                    tcd   
0359 FD88
0360 FD88              ;-----------------------------------------------------------
0361 FD88              ;
0362 FD88              ; Put the first pointer in CurPtr
0363 FD88              ;
0364 FD88 A5 05                 lda   PtrToFirstPtr
0365 FD8A 85 0D                 sta   CurPtr
0366 FD8C A5 07                 lda   PtrToFirstPtr+2
0367 FD8E 85 0F                 sta   CurPtr+2
0368 FD90
0369 FD90              ;
0370 FD90              ; Set y to 2 once and only once.
0371 FD90              ;
0372 FD90 A0 02 00              ldy   #2
0373 FD93              ;-----------------------------------------------------------
0374 FD93              ;
0375 FD93              ; Loop through, looking to see when CurPtr is equal to
0376 FD93              ; the Pointer that was passed.  If CurPtr is zero, we
0377 FD93              ; reached the end of the list and didn't find it.
0378 FD93              ;
0379 FD93              Loop      
0380 FD93 A7 0D                 lda   [CurPtr]
0381 FD95 17 0D                 ora   [CurPtr],y
0382 FD97 F0 0F                 beq   NoMatch
0383 FD99
0384 FD99 A7 0D                 lda   [CurPtr]                 ; is it this one?
0385 FD9B C5 09                 cmp   RoutinePtr
0386 FD9D D0 12                 bne   NotThisOne               ; no
0387 FD9F
0388 FD9F B7 0D                 lda   [CurPtr],y               ; maybe, look at high word
0389 FDA1 C5 0B                 cmp   RoutinePtr+2
0390 FDA3 D0 0C                 bne   NotThisOne
0391 FDA5
0392 FDA5              Match     
0393 FDA5 18                    clc   
0394 FDA6 80 01                 bra   Strip
0395 FDA8              NoMatch   
0396 FDA8 38                    sec   
0397 FDA9
0398 FDA9              Strip     
0399 FDA9 2B                    pld   
0400 FDAA FA                    plx   
0401 FDAB 68                    pla   
0402 FDAC 68                    pla   
0403 FDAD 68                    pla   
0404 FDAE 68                    pla   
0405 FDAF DA                    phx   
0406 FDB0 60                    rts   
0407 FDB1              ;-----------------------------------------------------------
0408 FDB1              ;
0409 FDB1              ; This was not the right one, so walk down the list by 
0410 FDB1              ; moving CurPtr to PriorPtr and putting the link
0411 FDB1              ; into CurPtr.  Go back to beginning of the loop.
0412 FDB1              ;
0413 FDB1              NotThisOne  
0414 FDB1
0415 FDB1 A7 0D                 lda   [CurPtr]                 ; move next to curPtr
0416 FDB3 AA                    tax   
0417 FDB4 B7 0D                 lda   [CurPtr],y
0418 FDB6 85 0F                 sta   CurPtr+2
0419 FDB8 86 0D                 stx   CurPtr
0420 FDBA
0421 FDBA 80 D7                 bra   Loop                     ; and loop
0422 FDBC
0423 FDBC                       ENDP 
0424 FDBC
0425 FDBC                       END   
